
; PicBasic Pro Compiler 2.40, (c) 1998, 2001 microEngineering Labs, Inc. All Rights Reserved. 
PM_USED			EQU	1

	INCLUDE	"16F84.INC"


; Define statements.
#define		lcd_dreg		 portb
#define		lcd_dbit		 4
#define		lcd_rsreg		 portb
#define		lcd_rsbit		 1
#define		lcd_reg		 portb
#define		lcd_ebit		 3
#define		lcd_bits		 4
#define		lcd_lines		 2

RAM_START       		EQU	0000Ch
RAM_END         		EQU	0004Fh
RAM_BANKS       		EQU	00001h
BANK0_START     		EQU	0000Ch
BANK0_END       		EQU	0004Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0213Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
T1              		EQU	RAM_START + 012h
T2              		EQU	RAM_START + 014h
FLAGS           		EQU	RAM_START + 016h
GOP             		EQU	RAM_START + 017h
RM1             		EQU	RAM_START + 018h
RM2             		EQU	RAM_START + 019h
RR1             		EQU	RAM_START + 01Ah
RR2             		EQU	RAM_START + 01Bh
_temp            		EQU	RAM_START + 01Ch
_elojel          		EQU	RAM_START + 01Eh
_PORTL           		EQU	PORTB
_PORTH           		EQU	PORTA
_TRISL           		EQU	TRISB
_TRISH           		EQU	TRISA
_temp_LOWBYTE    		EQU	_temp
#define _PORTA_2         	PORTA, 002h
#define _PORTA_4         	PORTA, 004h
#define _PORTA_3         	PORTA, 003h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
	INCLUDE	"VEVO84~1.MAC"
	INCLUDE	"PBPPIC14.LIB"

	MOVE?CB	010h, TRISA
	MOVE?CB	000h, TRISB
	MOVE?CT	000h, _PORTA_2
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	056h
	LCDOUT?C	065h
	LCDOUT?C	07Ah
	LCDOUT?C	065h
	LCDOUT?C	074h
	LCDOUT?C	065h
	LCDOUT?C	06Bh
	LCDOUT?C	020h
	LCDOUT?C	06Eh
	LCDOUT?C	065h
	LCDOUT?C	06Ch
	LCDOUT?C	06Bh
	LCDOUT?C	075h
	LCDOUT?C	06Ch
	LCDOUT?C	069h
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	064h
	LCDOUT?C	069h
	LCDOUT?C	067h
	LCDOUT?C	069h
	LCDOUT?C	074h
	LCDOUT?C	061h
	LCDOUT?C	06Ch
	LCDOUT?C	069h
	LCDOUT?C	073h
	LCDOUT?C	020h
	LCDOUT?C	068h
	LCDOUT?C	06Fh
	LCDOUT?C	06Dh
	LCDOUT?C	065h
	LCDOUT?C	072h
	LCDOUT?C	06Fh
	PAUSE?C	009C4h
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	048h
	LCDOUT?C	06Fh
	LCDOUT?C	06Dh
	LCDOUT?C	065h
	LCDOUT?C	072h
	LCDOUT?C	073h
	LCDOUT?C	065h
	LCDOUT?C	06Bh
	LCDOUT?C	06Ch
	LCDOUT?C	065h
	LCDOUT?C	074h
	LCDOUT?C	03Ah
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	054h
	LCDOUT?C	03Dh
	LCDOUT?C	02Dh
	LCDOUT?C	02Eh
	LCDOUT?C	02Dh
	LCDOUT?C	02Dh
	LCDOUT?C	020h
	LCDOUT?C	043h

	LABEL?L	_loop	
	SERIN2DPIN?T	_PORTA_4
	SERIN2MODE?C	0432Dh

	LABEL?L	L00001	
	SERIN2WAIT?CL	04Bh, L00001
	SERIN2?B	_temp_LOWBYTE
	SERIN2?B	_elojel
	MOVE?CT	001h, _PORTA_2
	PAUSE?C	014h
	MOVE?CT	000h, _PORTA_2
	SERPIN?T	_PORTA_3
	SERMODE?C	_T9600
	SEROUT?B	_temp_LOWBYTE
	SEROUT?B	_elojel
	MUL?BCW	_temp_LOWBYTE, 00Ah, _temp
	DIV?WCW	_temp, 002h, _temp
	CMPNE?BCL	_elojel, 000h, L00002
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	02Bh
	LCDOUTCOUNT?C	000h
	DIV?WCW	_temp, 00Ah, T1
	LCDOUTNUM?W	T1
	LCDOUTDEC?	
	LCDOUT?C	02Eh
	LCDOUTCOUNT?C	001h
	LCDOUTNUM?W	_temp
	LCDOUTDEC?	
	LCDOUT?C	020h
	LCDOUT?C	043h
	LABEL?L	L00002	
	CMPNE?BCL	_elojel, 0FFh, L00004
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	02Dh
	LCDOUTCOUNT?C	000h
	DIV?WCW	_temp, 00Ah, T1
	LCDOUTNUM?W	T1
	LCDOUTDEC?	
	LCDOUT?C	02Eh
	LCDOUTCOUNT?C	001h
	LCDOUTNUM?W	_temp
	LCDOUTDEC?	
	LCDOUT?C	020h
	LCDOUT?C	043h
	LABEL?L	L00004	
	CMPNE?BCB	_elojel, 000h, T1
	CMPNE?BCB	_elojel, 0FFh, T2
	LAND?BBW	T1, T2, T2
	CMPF?WL	T2, L00006
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	048h
	LCDOUT?C	069h
	LCDOUT?C	062h
	LCDOUT?C	061h
	LCDOUT?C	073h
	LCDOUT?C	020h
	LCDOUT?C	061h
	LCDOUT?C	064h
	LCDOUT?C	061h
	LCDOUT?C	074h
	LCDOUT?C	021h
	LABEL?L	L00006	
	GOTO?L	_loop
	END?	

	END
